import {
  Component,
  OnInit,
  Input,
  Output,
  EventEmitter
} from '@angular/core';
import { FhirFind } from '../../../mccf-data/fhir/fhir-find'

@Component({
  selector: 'app-fhir-find',
  templateUrl: './find.component.html',
  styleUrls: ['./find.component.css']
})
export class FhirFindComponent implements OnInit {
  @Input() results: Array<FhirFind> = []
  @Output() notify: EventEmitter<string> = new EventEmitter()

  constructor() { }

  ngOnInit() { }

  public setResource(ien: string) {
    this.notify.emit(ien)
  }

}
